/*
 * Decompiled with CFR 0.152.
 */
package edm.utils;

import com.nokia.mid.ui.FullCanvas;

public abstract class AnimatedCanvas
extends FullCanvas
implements Runnable {
    private static final int MILLIS_PER_TICK = 100;
    public volatile Thread animationThread = null;
    private int _animateSpeed = 100;

    public void setAnimateSpeed(int millis) {
        this._animateSpeed = millis;
    }

    public abstract void animate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTaken;
                if (currentThread != this.animationThread) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.isShown()) {
                    this.animate();
                    this.repaint(0, 0, this.getWidth(), this.getHeight());
                    this.serviceRepaints();
                }
                if ((timeTaken = System.currentTimeMillis() - startTime) < (long)this._animateSpeed) {
                    AnimatedCanvas animatedCanvas = this;
                    synchronized (animatedCanvas) {
                        this.wait((long)this._animateSpeed - timeTaken);
                        continue;
                    }
                }
                currentThread.yield();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }
}

