/*
 * Decompiled with CFR 0.152.
 */
package edm.mynokia.screensavers.watch.analog;

import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import edm.mynokia.MIDletMyNokia;
import edm.utils.AnimatedCanvas;
import edm.utils.MiscellaneousMath;
import java.util.Calendar;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class AnalogWatch
extends AnimatedCanvas {
    int diameter;
    int h;
    int titleHeight;
    int titleLenght;
    int w = this.getWidth();
    private Font titleFont;
    private final MIDletMyNokia parent;
    private String _sLastPlaytime = "";
    private boolean _lights = false;
    private int _time;
    private int fh;

    public AnalogWatch(MIDletMyNokia parent) {
        this.h = this.getHeight();
        this.titleFont = Font.getFont((int)0, (int)0, (int)0);
        this.fh = this.titleFont.getHeight();
        this.titleHeight = this.fh + 4;
        this.titleLenght = this.titleFont.stringWidth("00:00:00");
        this.diameter = this.h - 2;
        this.parent = parent;
    }

    public void animate() {
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -7: 
            case -6: 
            case -5: {
                this.parent.exitRequested();
                break;
            }
            case -1: {
                this._lights = true;
                DeviceControl.setLights((int)0, (int)100);
                break;
            }
            case -2: {
                this._lights = false;
                DeviceControl.setLights((int)0, (int)0);
            }
        }
    }

    protected void paint(Graphics g) {
        Calendar calendar = Calendar.getInstance();
        int k = calendar.get(10);
        int j = calendar.get(12);
        int i = calendar.get(13);
        if (this._time == i + j * 60 + k * 360) {
            return;
        }
        this._time = i + j * 60 + k * 360;
        g.setFont(this.titleFont);
        g.setGrayScale(255);
        g.fillRect(0, 0, this.w, this.h);
        int hour = k + (calendar.get(9) == 1 ? 12 : 0) - (k == 12 ? 12 : 0);
        String s3 = this.formatInteger(hour);
        String s1 = this.formatInteger(j);
        String s2 = this.formatInteger(i);
        String s = s3 + ":" + s1 + ":" + s2;
        g.setColor(128, 128, 128);
        g.drawString(s, (this.w - this.titleLenght) / 2, this.h - 12 - this.titleHeight, 20);
        g.translate(this.w / 2 - 1, this.h / 2);
        g.setGrayScale(0);
        g.setColor(0, 0, 0);
        g.drawArc(-this.diameter / 2, -this.diameter / 2, this.diameter, this.diameter, 0, 360);
        int k1 = 0;
        while (k1 < 12) {
            int byte0 = k1 % 3 == 0 ? 6 : 2;
            g.drawLine(MiscellaneousMath.CosFun(k1 * 30 - 90) * (this.diameter / 2) / 10000, MiscellaneousMath.SinFun(k1 * 30 - 90) * (this.diameter / 2) / 10000, MiscellaneousMath.CosFun(k1 * 30 - 90) * (this.diameter / 2 - byte0) / 10000, MiscellaneousMath.SinFun(k1 * 30 - 90) * (this.diameter / 2 - byte0) / 10000);
            ++k1;
        }
        g.drawLine(0, 0, MiscellaneousMath.CosFun(i * 6 - 90) * (this.diameter / 2 - 2) / 10000, MiscellaneousMath.SinFun(i * 6 - 90) * (this.diameter / 2 - 2) / 10000);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        this.calculatePoints(xPoints, yPoints, j * 6 + i / 10, this.diameter / 2 - 2, 7);
        dg.fillPolygon(xPoints, 0, yPoints, 0, yPoints.length, -16777216);
        this.calculatePoints(xPoints, yPoints, k * 30 + j / 2, this.diameter / 2 - 20, 9);
        dg.fillPolygon(xPoints, 0, yPoints, 0, yPoints.length, -16777216);
    }

    private void calculatePoints(int[] xPoints, int[] yPoints, int degrees, int len, int size) {
        xPoints[1] = MiscellaneousMath.CosFun((degrees -= 90) - size) * len / 20000;
        yPoints[1] = MiscellaneousMath.SinFun(degrees - size) * len / 20000;
        xPoints[2] = MiscellaneousMath.CosFun(degrees) * len / 10000;
        yPoints[2] = MiscellaneousMath.SinFun(degrees) * len / 10000;
        xPoints[3] = MiscellaneousMath.CosFun(degrees + size) * len / 20000;
        yPoints[3] = MiscellaneousMath.SinFun(degrees + size) * len / 20000;
    }

    private String formatInteger(int i) {
        if (i < 10) {
            return "0" + Integer.toString(i);
        }
        return Integer.toString(i);
    }
}

