/*
 * Decompiled with CFR 0.152.
 */
package edm.mynokia.screensavers.life;

import com.nokia.mid.ui.DeviceControl;
import edm.mynokia.MIDletMyNokia;
import edm.utils.AnimatedCanvas;
import java.util.Date;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LifeCanvas
extends AnimatedCanvas {
    private Command _exitCommand;
    private Command _redrawCommand;
    private Graphics _g;
    private Image _image;
    private final MIDletMyNokia parent;
    private Random _rnd;
    private boolean[][] nextLife;
    private boolean[][] thisLife;
    private int _aliveColor;
    private int _cellColumns;
    private int _cellRows;
    private int _cellSize;
    private int _deadColor;
    private int _delay;
    private int _generation;

    public LifeCanvas(MIDletMyNokia parent) {
        this.parent = parent;
        this._delay = 25;
        this._aliveColor = 0;
        this._deadColor = 0xFFFFFF;
        this._cellSize = 6;
        this._cellColumns = this.getWidth() / this._cellSize;
        this._cellRows = (this.getHeight() - this._cellSize * 2) / this._cellSize;
        this.thisLife = new boolean[this._cellColumns][this._cellRows];
        this.nextLife = new boolean[this._cellColumns][this._cellRows];
        this._rnd = new Random(new Date().getTime());
        this._generation = 0;
        this._aliveColor = 0x337722;
        this.randomise();
    }

    public void animate() {
        this.nextGeneration();
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -6: {
                this.randomise();
                break;
            }
            case -7: 
            case -5: {
                this.parent.exitRequested();
                break;
            }
            case -1: {
                DeviceControl.setLights((int)0, (int)100);
                break;
            }
            case -2: {
                DeviceControl.setLights((int)0, (int)0);
            }
        }
    }

    public void randomise() {
        this._generation = 0;
        int column = 0;
        while (column < this._cellColumns) {
            int row = 0;
            while (row < this._cellRows) {
                this.thisLife[column][row] = (this._rnd.nextInt() >>> 1) % 2 == 1;
                ++row;
            }
            ++column;
        }
    }

    protected void paint(Graphics g) {
        this._g = g;
        this.drawGrid();
        this.drawCells();
        this.drawInfo();
    }

    private void drawCells() {
        int column = 0;
        while (column < this._cellColumns) {
            int row = 0;
            while (row < this._cellRows) {
                this._g.setColor(this.thisLife[column][row] ? this._aliveColor : this._deadColor);
                this._g.fillRect(column * this._cellSize + 2, row * this._cellSize + 2, this._cellSize - 2, this._cellSize - 2);
                ++row;
            }
            ++column;
        }
    }

    private void drawGrid() {
        this._g.setColor(0xFFFFFF);
        this._g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this._g.setColor(0xEEEEEE);
        int column = 0;
        while (column < this._cellColumns + 1) {
            this._g.drawLine(column * this._cellSize, 0, column * this._cellSize, this._cellRows * this._cellSize);
            ++column;
        }
        int row = 0;
        while (row < this._cellRows + 1) {
            this._g.drawLine(0, row * this._cellSize, this._cellColumns * this._cellSize, row * this._cellSize);
            ++row;
        }
    }

    private void drawInfo() {
        this._g.setColor(0xFFFFFF);
        this._g.fillRect(0, this.getHeight() - this._cellSize * 2, this.getWidth(), this.getHeight());
        this._g.setColor(0);
        Graphics _tmp = this._g;
        Graphics _tmp1 = this._g;
        this._g.drawString("G: " + ++this._generation, this.getWidth(), this.getHeight() - this._cellSize * 2, 24);
        this._g.drawString("Redraw", 0, this.getHeight() - this._cellSize * 2, 20);
    }

    private int findNeighbours(int column, int row) {
        int n = 0;
        int right = (column + 1) % this._cellColumns;
        int left = (this._cellColumns + column - 1) % this._cellColumns;
        int bottom = (row + 1) % this._cellRows;
        int top = (this._cellRows + row - 1) % this._cellRows;
        if (this.thisLife[left][top]) {
            ++n;
        }
        if (this.thisLife[left][row]) {
            ++n;
        }
        if (this.thisLife[left][bottom]) {
            ++n;
        }
        if (this.thisLife[column][top]) {
            ++n;
        }
        if (this.thisLife[column][bottom]) {
            ++n;
        }
        if (this.thisLife[right][top]) {
            ++n;
        }
        if (this.thisLife[right][row]) {
            ++n;
        }
        if (this.thisLife[right][bottom]) {
            ++n;
        }
        return n;
    }

    private void nextGeneration() {
        int column = 0;
        while (column < this._cellColumns) {
            int row = 0;
            while (row < this._cellRows) {
                int n = this.findNeighbours(column, row);
                if (n <= 1) {
                    this.nextLife[column][row] = false;
                }
                if (n == 2) {
                    this.nextLife[column][row] = this.thisLife[column][row];
                }
                if (n == 3) {
                    this.nextLife[column][row] = true;
                }
                if (n >= 4) {
                    this.nextLife[column][row] = false;
                }
                ++row;
            }
            ++column;
        }
        boolean[][] swap = this.thisLife;
        this.thisLife = this.nextLife;
        this.nextLife = swap;
    }
}

