/*
 * Decompiled with CFR 0.152.
 */
package edm.mynokia.screensavers.fishtank;

import com.nokia.mid.ui.DeviceControl;
import edm.mynokia.MIDletMyNokia;
import edm.mynokia.screensavers.fishtank.Fish;
import edm.utils.AnimatedCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class FishTankCanvas
extends AnimatedCanvas {
    static final int NUM_PLANES = 5;
    static int waterWidth;
    static int waterHeight;
    private final MIDletMyNokia parent;
    private final Vector fishes = new Vector();

    public FishTankCanvas(MIDletMyNokia parent) {
        this.parent = parent;
        waterWidth = this.getWidth();
        waterHeight = this.getHeight();
        int numFishes = waterWidth * waterHeight / 1225;
        if (numFishes > 20) {
            numFishes = 20;
        }
        int i = 0;
        while (i < numFishes) {
            this.fishes.addElement(new Fish());
            ++i;
        }
    }

    public synchronized void animate() {
        int i = 0;
        while (i < this.fishes.size()) {
            Fish fish = (Fish)this.fishes.elementAt(i);
            fish.tick();
            ++i;
        }
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -7: 
            case -6: 
            case -5: {
                this.parent.exitRequested();
                break;
            }
            case -1: {
                DeviceControl.setLights((int)0, (int)100);
                break;
            }
            case -2: {
                DeviceControl.setLights((int)0, (int)0);
            }
        }
    }

    public void paint(Graphics g) {
        this.drawFishTank(g);
    }

    private synchronized void drawFishTank(Graphics g) {
        g.setColor(0, 255, 255);
        g.fillRect(0, 0, waterWidth, waterHeight);
        g.setColor(255, 128, 64);
        g.fillRect(0, waterHeight, waterWidth, this.getHeight());
        int plane = 0;
        while (plane < 5) {
            int i = 0;
            while (i < this.fishes.size()) {
                Fish fish = (Fish)this.fishes.elementAt(i);
                if (fish.getZ() == plane) {
                    fish.draw(g);
                }
                ++i;
            }
            ++plane;
        }
    }
}

