/*
 * Decompiled with CFR 0.152.
 */
package edm.mynokia.screensavers.fishtank;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import edm.mynokia.screensavers.fishtank.FishTankCanvas;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Fish {
    private static final int TYPE_NUM = 3;
    private static final int FRAME_NUM = 2;
    private static final Image[][] fishImage;
    private static final int fishWidth;
    private static final int fishHeight;
    private static final Random random;
    private final int type = Fish.rand(3);
    private int frame = Fish.rand(2);
    private int ticksSinceLastChangeD = 0;
    private int ticksSinceLastChangeX = 0;
    private int ticksSinceLastChangeY = 0;
    private int vx;
    private int vy;
    private int x = Fish.rand(FishTankCanvas.waterWidth - fishWidth);
    private int y = Fish.rand(FishTankCanvas.waterHeight - fishHeight);
    private int z;

    public Fish() {
        this.vx = Fish.rand(2) * 2 - 1;
        this.vy = Fish.rand(3) - 1;
        this.z = Fish.rand(5);
    }

    public void draw(Graphics g) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        Image img = fishImage[this.type][this.frame];
        if (img != null) {
            if (this.vx < 0) {
                dg.drawImage(img, this.x, this.y, 20, 8192);
            } else {
                dg.drawImage(img, this.x, this.y, 20, 0);
            }
        }
        this.frame = (this.frame + Fish.rand(2)) % 2;
    }

    public void tick() {
        ++this.ticksSinceLastChangeX;
        ++this.ticksSinceLastChangeY;
        ++this.ticksSinceLastChangeD;
        if (this.ticksSinceLastChangeX > 20 && Fish.rand(20) == 0) {
            this.vx = Fish.rand(2) * 2 - 1;
            this.ticksSinceLastChangeX = 0;
        }
        if (this.vx < 0 && this.x + this.vx < 0 || this.vx > 0 && this.x + fishWidth + this.vx > FishTankCanvas.waterWidth) {
            this.vx = -this.vx;
            this.ticksSinceLastChangeX = 0;
        }
        if (this.ticksSinceLastChangeY > 20 && Fish.rand(20) == 0) {
            this.vy = Fish.rand(3) - 1;
            this.ticksSinceLastChangeY = 0;
        }
        if (this.vy < 0 && this.y + this.vy < 0 || this.vy > 0 && this.y + fishHeight + this.vy > FishTankCanvas.waterHeight) {
            this.vy = Fish.rand(2) == 0 ? -this.vy : 0;
            this.ticksSinceLastChangeY = 0;
        }
        if (this.ticksSinceLastChangeD > 10 && Fish.rand(10) == 0) {
            this.z += Fish.rand(3) - 1;
            if (this.z < 0 || this.z == 5) {
                this.z = Fish.rand(2) == 0 ? (this.z < 0 ? 0 : this.z - 1) : (this.z < 0 ? 1 : this.z - 2);
            }
            this.ticksSinceLastChangeD = 0;
        }
        this.x += this.vx;
        this.y += this.vy;
    }

    int getZ() {
        return this.z;
    }

    static int rand(int scale) {
        return (random.nextInt() << 1 >>> 1) % scale;
    }

    static {
        random = new Random();
        fishImage = new Image[3][2];
        int i = 0;
        int k = 0;
        try {
            i = 0;
            while (i < 3) {
                k = 0;
                while (k < 2) {
                    Fish.fishImage[i][k] = Image.createImage((String)("/fish" + i + k + ".png"));
                    ++k;
                }
                ++i;
            }
        }
        catch (IOException e) {
            Fish.fishImage[i][k] = null;
        }
        fishWidth = fishImage[0][0].getWidth();
        fishHeight = fishImage[0][0].getHeight();
    }
}

